//=============================================================================
// Ricon_SRPG_HandleUsingSkill.js
// Version: 1.0.0
//----------------------------------------------------------------------------
// Copyright (c) 2024 RiceConstruction
//----------------------------------------------------------------------------
// Versions
// 1.0.0 2024/06/12 初版
//----------------------------------------------------------------------------
// [ホームページ] https://riceconstruction.weebly.com/
// [GitHub] https://github.com/RiceConstruction/
// [Twitter] https://twitter.com/riceconstr/
// [Fantia] https://fantia.jp/rice-construction/
//=============================================================================

/*:
 * @target MV
 * @plugindesc SRPGギア用使用スキル記録プラグイン
 * @author べるろ＊(Ricon)
 * @base SRPG_core_MZ
 *
 * @help Ricon_SRPG_HandleUsingSkill.js
 *
 * SRPGギア for MZを用いた戦闘で、戦闘中にスキルを選択した際、
 * 使用したスキルタイプに応じてゲーム内変数・スイッチを操作します。
 * 対象の変数・スイッチの値はアクターがスキルを選択した時点で操作されます。
 *
 * ----------------------------------------------------------------------------
 *
 * 【プラグインコマンド】
 *
 * このプラグインにはプラグインコマンドはありません。
 *
 * ----------------------------------------------------------------------------
 *
 * @param usingStypeVariableId
 * @text スキルタイプID記録変数ID
 * @desc 使用したスキルのスキルタイプIDを記録する変数ID
 * @type variable
 * @default 0
 *
 * @param usingStypeSwitches
 * @text スキルタイプID記録スイッチID
 * @desc 使用したスキルのスキルタイプに応じてONにするスイッチの設定
 * @type struct<Switches>[]
 * @default []
 *
 */
/*~struct~Switches:
 *
 * @param stypeId
 * @text スキルタイプID
 * @desc スキルタイプID
 * @type number
 * @default 0
 *
 * @param switchId
 * @text スイッチID
 * @desc スキルタイプIDに応じてONにするスイッチID
 * @type switch
 * @default 0
 *
 */

'use strict';

/**
 * RiceConstruction global namespace.
 * @namespace
 */
var Ricon = Ricon || {};

{
  const plugin = (Ricon.SRPG_HandleUsingSkill =
    Ricon.SRPG_HandleUsingSkill || {});

  //==========================================================================
  // Constant
  //==========================================================================

  const CONSTANTS = (plugin.constants = {
    PLUGIN_NAME: 'Ricon_SRPG_HandleUsingSkill',
    PLUGIN_COMMAND: '',
    OPERATION_MODE: {
      SHOW: ''
    }
  });

  //==========================================================================
  // Utility
  //==========================================================================

  const parseNumber = (plugin.parseNumber = (value, defaultValue = 0) => {
    const parsedValue = parseInt(value);
    return !isNaN(parsedValue) ? parsedValue : defaultValue;
  });

  const parseObject = (plugin.parseObject = (value) => {
    if (!value) return {};
    try {
      return JSON.parse(value);
    } catch (e) {
      return {};
    }
  });

  const parseArray = (plugin.parseArray = (value) => {
    if (!value) return [];
    try {
      const parsedValue = JSON.parse(value);
      if (!Array.isArray(parsedValue)) return [];
      return parsedValue;
    } catch (e) {
      return [];
    }
  });

  //==========================================================================
  // Parameter
  //==========================================================================

  const parseParameters = (plugin.parseParameters = (json) => ({
    usingStypeVariableId: parseNumber(json.usingStypeVariableId),
    usingStypeSwitches: parseArray(json.usingStypeSwitches).map((data) => {
      const obj = parseObject(data);
      return {
        stypeId: parseNumber(obj.stypeId),
        switchId: parseNumber(obj.switchId)
      };
    })
  }));

  const parameters = (plugin.parameters = parseParameters(
    PluginManager.parameters(CONSTANTS.PLUGIN_NAME)
  ));

  //==========================================================================
  // Function
  //==========================================================================

  /**
   * 使用したスキルタイプに応じた変数・スイッチの操作
   */
  const handleUsingSkill = (plugin.handleUsingSkill = (stypeId) => {
    $gameVariables.setValue(parameters.usingStypeVariableId, stypeId);
    parameters.usingStypeSwitches.forEach((data) => {
      $gameSwitches.setValue(data.switchId, data.stypeId === stypeId);
    });
  });

  //==========================================================================
  // Backup
  //==========================================================================

  const bk = (plugin.bk = {});

  //==========================================================================
  // Scene_Map
  //==========================================================================

  bk.Scene_Map_onSkillOk = Scene_Map.prototype.onSkillOk;
  Scene_Map.prototype.onSkillOk = function () {
    const stypeId = this._skillWindow._stypeId;
    handleUsingSkill(stypeId);
    bk.Scene_Map_onSkillOk.call(this);
  };
}
